CREATE TABLE `device_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `is_app` tinyint(1) NOT NULL DEFAULT 0,
  `token` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `user_notifications` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remark` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `click_value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


ALTER TABLE `general_settings` ADD `pn` TINYINT(1) NOT NULL DEFAULT '0' AFTER `sn`;
ALTER TABLE `notification_templates` ADD `push_notification_status` TINYINT(1) NOT NULL DEFAULT '1' AFTER `sms_status`;
ALTER TABLE `notification_templates` ADD `push_notification_body` TEXT NULL DEFAULT NULL AFTER `sms_body`;
UPDATE `notification_templates` SET `push_notification_body` = '{{amount}} {{site_currency}} has been added to your account' WHERE `notification_templates`.`act` = "BAL_ADD";
UPDATE `notification_templates` SET `push_notification_body` = '{{amount}} {{site_currency}} has been subtracted from your account' WHERE `notification_templates`.`act` = "BAL_SUB";

UPDATE `notification_templates` SET `push_notification_body` = '{{amount}} {{site_currency}} deposited successfully via  {{method_name}}' WHERE `notification_templates`.`act` = "DEPOSIT_COMPLETE";

UPDATE `notification_templates` SET `push_notification_body` = '{{amount}} {{site_currency}} deposit request via  {{method_name}} approved successfully' WHERE `notification_templates`.`act` = "DEPOSIT_APPROVE";

UPDATE `notification_templates` SET `push_notification_body` = 'Your deposit request of {{amount}} {{site_currency}} via {{method_name}} is rejected' WHERE `notification_templates`.`act` = "DEPOSIT_REJECT";

UPDATE `notification_templates` SET `push_notification_body` = 'Your deposit request of {{amount}} {{site_currency}} via {{method_name}} is submitted successfully' WHERE `notification_templates`.`act` = "DEPOSIT_REQUEST";

UPDATE `notification_templates` SET `push_notification_body` = 'Your account recovery code is: {{code}}' WHERE `notification_templates`.`act` = "PASS_RESET_CODE";

UPDATE `notification_templates` SET `push_notification_body` = 'Your password has been changed successfully' WHERE `notification_templates`.`act` = "PASS_RESET_DONE";

UPDATE `notification_templates` SET `push_notification_body` = 'Your Ticket#{{ticket_id}} :  {{ticket_subject}} has been replied.' WHERE `notification_templates`.`act` = "ADMIN_SUPPORT_REPLY";


UPDATE `notification_templates` SET `push_notification_body` = 'Your mobile verification code is: {{code}}' WHERE `notification_templates`.`act` = "SVER_CODE";

UPDATE `notification_templates` SET `push_notification_body` = 'Your withdraw request of {{amount}} {{site_currency}} via {{method_name}} has been approved' WHERE `notification_templates`.`act` = "WITHDRAW_APPROVE";

UPDATE `notification_templates` SET `push_notification_body` = 'Your withdraw request of {{amount}} {{site_currency}} via {{method_name}} has been rejected' WHERE `notification_templates`.`act` = "WITHDRAW_REJECT";
UPDATE `notification_templates` SET `push_notification_body` = 'Your withdraw request of {{amount}} {{site_currency}} via {{method_name}} submitted successfully' WHERE `notification_templates`.`act` = "WITHDRAW_REQUEST";

UPDATE `notification_templates` SET `push_notification_body` = '{{message}}' WHERE `notification_templates`.`act` = "DEFAULT";
UPDATE `notification_templates` SET `push_notification_body` = 'Your kyc verification completed successfully' WHERE `notification_templates`.`act` = "KYC_APPROVE";
UPDATE `notification_templates` SET `push_notification_body` = 'Your kyc verification has been rejected' WHERE `notification_templates`.`act` = "KYC_REJECT";
UPDATE `notification_templates` SET `push_notification_body` = 'Your loan application approved successfully' WHERE `notification_templates`.`act` = "LOAN_APPROVE";
UPDATE `notification_templates` SET `push_notification_body` = 'Your loan application has been rejected' WHERE `notification_templates`.`act` = "LOAN_REJECT";
UPDATE `notification_templates` SET `push_notification_body` = 'Loan installment due' WHERE `notification_templates`.`act` = "LOAN_INSTALLMENT_DUE";
UPDATE `notification_templates` SET `push_notification_body` = 'Loan installment paid' WHERE `notification_templates`.`act` = "LOAN_PAID";

ALTER TABLE `general_settings` ADD `push_configuration` TEXT NULL DEFAULT NULL AFTER `sms_config`;

